(* ::Package:: *)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This code decomposes MP shocks into exp rates and TP, for the unconventional policy period during COVID period
% Created for Hambur and Haque (2023) based on KMS
% Baseline estimates code

%% Very similair to  Code_for _HF _shock _through _ACM1

% Writtin bey Jonathan Hambur June 2022

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Options

clear all
close all
restoredefaultpath
% Links to some codes this draws on
addpath('Code\Nom ATSM') % Contains some of the sub-functions
addpath('\Code\Decomposing shocks\Subs') % Contains some of the sub-functions
addpath('Code\Decomposing shocks\additional');
clc
options = optimoptions('fsolve','Display','off');

% paramS.NoF=3; % Number of fractors
irf_pc = 2;
yield_select = [1;12;24;36;60;120];



% yield_select = [2:120];

% Select the ATSM model we want - number of parameters, survey or bootstrap etc
load('Input data\Nom ATSM\paramM93_S_ 4fac_cash _both _highsd _ 2022.mat');
load('Input data\Nom ATSM\M93_S_ 4fac_cash _both _highsd _ 2022.mat');
MS=M;
clear M;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Start

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load and format data - bring in data for one and 2 day change (and pre and post) for flexbility - preffered is one day cahnge


opts = spreadsheetImportOptions;
opts = detectImportOptions('\Input data\HF zcr\input\Announcement ZCR.xls');
opts = setvaropts(opts,{'Date'},'InputFormat','dd/MM/uuuu'); 
opts.Sheet='Change';
changes = readtable('\\ Input data\HF zcr\input\Announcement ZCR.xls',opts);

opts = spreadsheetImportOptions;
opts = detectImportOptions('\\ Input data\HF zcr\input\Announcement ZCR.xls');
opts = setvaropts(opts,{'Date'},'InputFormat','dd/MM/uuuu'); 
opts.Sheet='Change_ 2';
changes_ 2 = readtable('\\ Input data\HF zcr\input\Announcement ZCR.xls',opts);

opts = spreadsheetImportOptions;
opts = detectImportOptions('\\ Input data\HF zcr\input\Announcement ZCR.xls');
opts = setvaropts(opts,{'Date'},'InputFormat','dd/MM/uuuu'); 
opts.Sheet='pre';
pre = readtable('\\ Input data\HF zcr\input\Announcement ZCR.xls',opts);


opts = spreadsheetImportOptions;
opts = detectImportOptions('\\ Input data\HF zcr\input\Announcement ZCR.xls');
opts = setvaropts(opts,{'Date'},'InputFormat','dd/MM/uuuu'); 
opts.Sheet='post';
post = readtable('\\ Input data\HF zcr\input\Announcement ZCR.xls',opts);

opts = spreadsheetImportOptions;
opts = detectImportOptions('\\ Input data\HF zcr\input\Announcement ZCR.xls');
opts = setvaropts(opts,{'Date'},'InputFormat','dd/MM/uuuu'); 
opts.Sheet='post_ 2';
post2 = readtable('\\ Input data\HF zcr\input\Announcement ZCR.xls',opts);


DataYields.old= csvread('\Input data\Nom ATSM\Yields_m - EXTRA.csv'); % full dara series for comparison
data.Yields.old=DataYields.old(2:size(DataYields.old,1),3:size(DataYields.old,2));


%% Set up storage as only have quarterly - need to interpolate between quarterly observatons
len = size( changes,1);

dates= changes(:,1);
changes=changes(:,2:end);
changes_ 2=changes_ 2(:,2:end);
post=post(:,2:end);
post2=post2(:,2:end);

pre=pre(:,2:end);

yields.ext = zeros(len,121);
yields.ext2 = zeros(len,121);
yields.pre = zeros(len,121);
yields.post = zeros(len,121);
yields.post2 = zeros(len,121);

%% Interpolate for missing months as only q freq in F17
yields.ext(:,1)=table2array (changes(:,1))./100;
yields.ext2(:,1)=table2array (changes_ 2(:,1))./100;
yields.pre(:,1)=table2array (pre(:,1))./100;
yields.post(:,1)=table2array (post(:,1))./100;
yields.post2(:,1)=table2array (post2(:,1))./100;

for i = 1:40
    yields.ext(:,1+i*3)=table2array (changes(:,1+i))./100;
    yields.ext2(:,1+i*3)=table2array (changes_ 2(:,1+i))./100;
    yields.pre(:,1+i*3)=table2array (pre(:,1+i))./100;
    yields.post(:,1+i*3)=table2array (post(:,1+i))./100;
    yields.post2(:,1+i*3)=table2array (post2(:,1+i))./100;
      
end

for i = 1:40
	gap = (yields.ext(:,i*3+1)-yields.ext(:,(i-1)*3+1))/3;
    yields.ext(:,(i-1)*3+1+1)=yields.ext(:,(i-1)*3+1)+gap;
    yields.ext(:,(i-1)*3+1+2)=yields.ext(:,(i-1)*3+1)+2*gap;
	gap2 = (yields.ext2(:,i*3+1)-yields.ext2(:,(i-1)*3+1))/3;
    yields.ext2(:,(i-1)*3+1+1)=yields.ext2(:,(i-1)*3+1)+gap2;
    yields.ext2(:,(i-1)*3+1+2)=yields.ext2(:,(i-1)*3+1)+2*gap2;  
	
    gappre = (yields.pre(:,i*3+1)-yields.pre(:,(i-1)*3+1))/3;
    yields.pre(:,(i-1)*3+1+1)=yields.pre(:,(i-1)*3+1)+gappre;
    yields.pre(:,(i-1)*3+1+2)=yields.pre(:,(i-1)*3+1)+2*gappre; 
	
    gappost = (yields.post(:,i*3+1)-yields.post(:,(i-1)*3+1))/3;
    yields.post(:,(i-1)*3+1+1)=yields.post(:,(i-1)*3+1)+gappost;
    yields.post(:,(i-1)*3+1+2)=yields.post(:,(i-1)*3+1)+2*gappost;     

    gappost2 = (yields.post2(:,i*3+1)-yields.post2(:,(i-1)*3+1))/3;
    yields.post2(:,(i-1)*3+1+1)=yields.post2(:,(i-1)*3+1)+gappost2;
    yields.post2(:,(i-1)*3+1+2)=yields.post2(:,(i-1)*3+1)+2*gappost2;    
end
yields.ext = yields.ext(:,3:end);
yields.ext2 = yields.ext2(:,3:end);
yields.pre = yields.pre(:,3:end);
yields.post = yields.post(:,3:end);
yields.post2 = yields.post2(:,3:end);

% Rescale yeilds and factors spo similair scaling

Amean_old = mean(data.Yields.old); % mean from old data. Take this off so this data has negatvive mean
% Signals_mat = (A_mat-Amean_old(Amean,[2*len,1]))*paramS.PC;
% std_signals = std(Signals_mat);
% Making sure to scale so on same level as PC
B=(yields.pre-repmat(Amean_old,[len,1]));
M.pcspre=(B*paramS.PC);
B=(yields.post-repmat(Amean_old,[len,1]));
M.pcspost=(B*paramS.PC);
B=(yields.post2-repmat(Amean_old,[len,1]));
M.pcspost2=(B*paramS.PC);


%% Run through ATSM
M.pcs = yields.ext*paramS.PC;
M.pcs2 = yields.ext2*paramS.PC;

M.y.change=fit_y(M.pcs, paramS.An, paramS.Bn, len ,paramS.maxdate);
M.yrfexp.change=fit_y(M.pcs, paramS.Anrfexp, paramS.Bnrfexp, len ,paramS.maxdate);
 
M.y.change2=fit_y(M.pcs2, paramS.An, paramS.Bn, len ,paramS.maxdate);
M.yrfexp.change2=fit_y(M.pcs2, paramS.Anrfexp, paramS.Bnrfexp, len ,paramS.maxdate);

M.y.pre=fit_y(M.pcspre, paramS.An, paramS.Bn, len ,paramS.maxdate);
M.yrfexp.pre=fit_y(M.pcspre, paramS.Anrfexp, paramS.Bnrfexp, len ,paramS.maxdate);

M.y.post=fit_y(M.pcspost, paramS.An, paramS.Bn, len ,paramS.maxdate);
M.yrfexp.post=fit_y(M.pcspost, paramS.Anrfexp, paramS.Bnrfexp, len ,paramS.maxdate);

M.y.post2=fit_y(M.pcspost2, paramS.An, paramS.Bn, len ,paramS.maxdate);
M.yrfexp.post2=fit_y(M.pcspost2, paramS.Anrfexp, paramS.Bnrfexp, len ,paramS.maxdate);


M.y.changelvl=M.y.post-M.y.pre;
M.yrfexp.changelvl=M.yrfexp.post-M.yrfexp.pre;


M.y.changelvl2=M.y.post2-M.y.pre;
M.yrfexp.changelvl2=M.yrfexp.post2-M.yrfexp.pre;
% Average TP
M.tp.change=M.y.change-M.yrfexp.change;
M.tp.change2=M.y.change2-M.yrfexp.change2;
M.tp.pre=M.y.pre-M.yrfexp.pre;
M.tp.post=M.y.post-M.yrfexp.post;
M.tp.post2=M.y.post2-M.yrfexp.post2;
M.tp.changelvl=M.tp.post-M.tp.pre;
M.tp.changelvl2=M.tp.post2-M.tp.pre;

%% Take PC and decompose
t=len;
%% Approach 3
pc_input = standardise(M.yrfexp.changelvl(:,yield_select));
%[PC, Mean,V,X]= pca1(test);
[pc2,W2]=extract(pc_input,2);
SK.X.exp.old=pc2;
 SK.PC.exp.old=W2';
SK.V.exp.old=mean(W2.^2,2);

chck=-1;
while chck<0
x0=vec(getqr(randn(2,2)));
f = @(x)rotate_pc(x,W2(:,1));
[out,fval,exitflag]=fsolve(f,x0,options);
[F,U]=rotate_pc(out,W2(:,1));
pc0=pc2*U;
w20=pc0\pc_input;
if w20(1,1)>0 && w20(2,end)>0
    chck=1;
end
end

SK.PCR.exp.old=w20';
SK.XR.exp.old=pc0;


% Now do regression of TP on expected
temp.z = [ones(t,1), SK.XR.exp.old].';
temp.a = M.tp.changelvl(:,2:end)'*temp.z.'*inv(temp.z*temp.z.');
temp.residuals= M.tp.changelvl(:,2:end)-(temp.a*temp.z).'; 

pc_input = standardise(temp.residuals);
%[PC, Mean,V,X]= pca1(test);
[pc3,W3]=extract(pc_input,2);
SK.X.tp.old=pc3;
 SK.PC.tp.old=W3';
SK.V.tp.old=mean(W3.^2,2);
% TP

chck=-1;
while chck<0
x0=vec(getqr(randn(2,2)));
f = @(x)rotate_pc(x,W3(:,1));
[out,fval,exitflag]=fsolve(f,x0,options);
[F,U]=rotate_pc(out,W3(:,1));
tp0=pc3*U;
w30=tp0\pc_input;
if w30(1,1)>0 && w30(2,end)>0
    chck=1;
end
end

SK.PCR.tp.old=w30';
SK.XR.tp.old=tp0;


%% Approach 3 two day change
pc_input = standardise(M.yrfexp.changelvl2(:,yield_select));
%[PC, Mean,V,X]= pca1(test);
[pc2,W2]=extract(pc_input,2);
SK.X.exp.old2=pc2;
 SK.PC.exp.old2=W2';
SK.V.exp.old2=mean(W2.^2,2);
% 


chck=-1;
while chck<0
x0=vec(getqr(randn(2,2)));
f = @(x)rotate_pc(x,W2(:,1));
[out,fval,exitflag]=fsolve(f,x0,options);
[F,U]=rotate_pc(out,W2(:,1));
pc0=pc2*U;
w20=pc0\pc_input;
if w20(1,1)>0 && w20(2,end)>0
    chck=1;
end
end

SK.PCR.exp.old2=w20';
SK.XR.exp.old2=pc0;


% Now do regression of TP on expected
temp.z = [ones(t,1), SK.XR.exp.old2].';
temp.a = M.tp.changelvl2(:,2:end)'*temp.z.'*inv(temp.z*temp.z.');
temp.residuals= M.tp.changelvl2(:,2:end)-(temp.a*temp.z).'; 

pc_input = standardise(temp.residuals);
%[PC, Mean,V,X]= pca1(test);
[pc3,W3]=extract(pc_input,2);
SK.X.tp.old2=pc3;
 SK.PC.tp.old2=W3';
SK.V.tp.old2=mean(W3.^2,2);
% TP

chck=-1;
while chck<0
x0=vec(getqr(randn(2,2)));
f = @(x)rotate_pc(x,W3(:,1));
[out,fval,exitflag]=fsolve(f,x0,options);
[F,U]=rotate_pc(out,W3(:,1));
tp0=pc3*U;
w30=tp0\pc_input;
if w30(1,1)>0 && w30(2,end)>0
    chck=1;
end
end

SK.PCR.tp.old2=w30';
SK.XR.tp.old2=tp0;


%% reg of curve changes on PC to find shares expalined
clear temp
temp.z = [ones(t,1), SK.XR.exp.old(:,1)].';
temp.a = M.y.changelvl(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.exppc1.old.beta=temp.a;
decomp.exppc1.old.fit=temp.fit;
decomp.exppc1.old.sse=temp.SSE;

clear temp
temp.z = [ones(t,1), SK.XR.exp.old(:,2)].';
temp.a = M.y.changelvl(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.exppc2.old.beta=temp.a;
decomp.exppc2.old.fit=temp.fit;
decomp.exppc2.old.sse=temp.SSE;

clear temp
temp.z = [ones(t,1), SK.XR.tp.old(:,2)].';
temp.a = M.y.changelvl(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.tppc1.old.beta=temp.a;
decomp.tppc1.old.fit=temp.fit;
decomp.tppc1.old.sse=temp.SSE;

clear temp
temp.z = [ones(t,1), SK.XR.tp.old(:,1)].';
temp.a = M.y.changelvl(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.tppc2.old.beta=temp.a;
decomp.tppc2.old.fit=temp.fit;
decomp.tppc2.old.sse=temp.SSE;


clear temp
temp.z = [ones(t,1), SK.X.tp.old(:,1)].';
temp.a = M.y.changelvl(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.tpdir.old.beta=temp.a;
decomp.tpdir.old.fit=temp.fit;
decomp.tpdir.old.sse=temp.SSE;


contrs=zeros(t,5,6);
for i = 1:6
    contrs(:,:,i)=[decomp.exppc1.old.fit(:,i), decomp.exppc2.old.fit(:,i), decomp.tppc1.old.fit(:,i), decomp.tppc2.old.fit(:,i) decomp.tpdir.old.fit(:,i) ];
end

writematrix(contrs(:,:,1), '\\ Outputs\HF decomp\contrs_1m_unconv.csv')
writematrix(contrs(:,:,2), '\\ Outputs\HF decomp\contrs_1year_unconv.csv')
writematrix(contrs(:,:,3), '\\ Outputs\HF decomp\contrs_2year_unconv.csv')
writematrix(contrs(:,:,4), '\\ Outputs\HF decomp\contrs_3year_unconv.csv')
writematrix(contrs(:,:,5), '\\ Outputs\HF decomp\contrs_5year_unconv.csv')
writematrix(contrs(:,:,6), '\\ Outputs\HF decomp\contrs_10year_unconv.csv')



%% reg of curve changes on PC to find shares expalined 2 day
clear temp
temp.z = [ones(t,1), SK.XR.exp.old2(:,1)].';
temp.a = M.y.changelvl2(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl2(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.exppc1.old.beta=temp.a;
decomp.exppc1.old.fit=temp.fit;
decomp.exppc1.old.sse=temp.SSE;

clear temp
temp.z = [ones(t,1), SK.XR.exp.old2(:,2)].';
temp.a = M.y.changelvl2(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl2(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.exppc2.old.beta=temp.a;
decomp.exppc2.old.fit=temp.fit;
decomp.exppc2.old.sse=temp.SSE;

clear temp
temp.z = [ones(t,1), SK.XR.tp.old2(:,2)].';
temp.a = M.y.changelvl2(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl2(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.tppc1.old.beta=temp.a;
decomp.tppc1.old.fit=temp.fit;
decomp.tppc1.old.sse=temp.SSE;

clear temp
temp.z = [ones(t,1), SK.XR.tp.old2(:,1)].';
temp.a = M.y.changelvl2(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl2(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.tppc2.old.beta=temp.a;
decomp.tppc2.old.fit=temp.fit;
decomp.tppc2.old.sse=temp.SSE;


clear temp
temp.z = [ones(t,1), SK.X.tp.old2(:,1)].';
temp.a = M.y.changelvl2(:,yield_select)'*temp.z.'*inv(temp.z*temp.z.');
temp.fit= (temp.a*temp.z).'; 
temp.residuals= M.y.changelvl2(:,yield_select)-(temp.a*temp.z).'; 
temp.residuals2 = temp.residuals.^2;
temp.SSE=sum(sum(temp.residuals2,1),2);

decomp.tpdir.old.beta=temp.a;
decomp.tpdir.old.fit=temp.fit;
decomp.tpdir.old.sse=temp.SSE;


contrs2=zeros(t,5,6);
for i = 1:6
    contrs2(:,:,i)=[decomp.exppc1.old.fit(:,i), decomp.exppc2.old.fit(:,i), decomp.tppc1.old.fit(:,i), decomp.tppc2.old.fit(:,i) decomp.tpdir.old.fit(:,i) ];
end

writematrix(contrs2(:,:,1), '\\ Outputs\HF decomp\contrs_1m_unconv2.csv')
writematrix(contrs2(:,:,2), '\\ Outputs\HF decomp\contrs_1year_unconv2.csv')
writematrix(contrs2(:,:,3), '\\ Outputs\HF decomp\contrs_2year_unconv2.csv')
writematrix(contrs2(:,:,4), '\\ Outputs\HF decomp\contrs_3year_unconv2.csv')
writematrix(contrs2(:,:,5), '\\ Outputs\HF decomp\contrs_5year_unconv2.csv')
writematrix(contrs2(:,:,6), '\\ Outputs\HF decomp\contrs_10year_unconv2.csv')



%% Export basic series
export_yields _pre = array2table(M.y.pre);
export_yields _pre = [dates, export_yields _pre];
writetable(export_yields _pre,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yields_pre');

export_yields _post = array2table(M.y.post);
export_yields _post = [dates, export_yields _post];
writetable(export_yields _post,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yields_post') ;  

export_yields _post2 = array2table(M.y.post2);
export_yields _post2 = [dates, export_yields _post2];
writetable(export_yields _post2,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yields_post2') ;  


export_yields _changelvl = array2table(M.y.changelvl);
export_yields _changelvl = [dates, export_yields _changelvl];
writetable(export_yields _changelvl,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yields_changelvl') ;  

export_yields _changelvl2 = array2table(M.y.changelvl2);
export_yields _changelvl2 = [dates, export_yields _changelvl2];
writetable(export_yields _changelvl2,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yields_changelvl2') ;  


export_yrfexp _pre = array2table(M.yrfexp.pre);
export_yrfexp _pre = [dates, export_yrfexp _pre];
writetable(export_yrfexp _pre,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yrfexp_pre');

export_yrfexp _post = array2table(M.yrfexp.post);
export_yrfexp _post = [dates, export_yrfexp _post];
writetable(export_yrfexp _post,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yrfexp_post') ;  

export_yrfexp _post2 = array2table(M.yrfexp.post2);
export_yrfexp _post2 = [dates, export_yrfexp _post2];
writetable(export_yrfexp _post2,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yrfexp_post2') ; 

export_yrfexp _changelvl = array2table(M.yrfexp.changelvl);
export_yrfexp _changelvl = [dates, export_yrfexp _changelvl];
writetable(export_yrfexp _changelvl,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yrfexp_changelvl') ; 

export_yrfexp _changelvl2 = array2table(M.yrfexp.changelvl2);
export_yrfexp _changelvl2 = [dates, export_yrfexp _changelvl2];
writetable(export_yrfexp _changelvl2,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','yrfexp_changelvl2') ; 


export_tp _pre = array2table(M.tp.pre);
export_tp _pre = [dates, export_tp _pre];
writetable(export_tp _pre,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','tp_pre');

export_tp _post = array2table(M.tp.post);
export_tp _post = [dates, export_tp _post];
writetable(export_tp _post,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','tp_post') ;  

export_tp _post2 = array2table(M.tp.post2);
export_tp _post2 = [dates, export_tp _post2];
writetable(export_tp _post2,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','tp_post2') ; 

export_tp _changelvl = array2table(M.tp.changelvl);
export_tp _changelvl = [dates, export_tp _changelvl];
writetable(export_tp _changelvl,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','tp_changelvl') ; 

export_tp _changelvl2 = array2table(M.tp.changelvl2);
export_tp _changelvl2 = [dates, export_tp _changelvl2];
writetable(export_tp _changelvl2,'\\ Outputs\HF decomp\Unconv_policy_decomp.xlsx','Sheet','tp_changelvl2') ; 

  


